package ru.yandex.chemodan.app.djfs.core.filesystem.exception;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;

public class ResourceNotFoundException extends FilesystemException {
    public final DjfsResourcePath path;

    public ResourceNotFoundException(String path) {
        super("Resource not found for path: " + path);
        this.path = null;
    }

    public ResourceNotFoundException(DjfsResourcePath path) {
        super("Resource not found for path: " + path.getFullPath());
        this.path = path;
    }
}
