package ru.yandex.chemodan.app.djfs.core.filesystem.exception;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;

public class SourceIsParentForDestinationException extends FilesystemException {
    public final DjfsResourcePath sourcePath;
    public final DjfsResourcePath destinationPath;

    public SourceIsParentForDestinationException(DjfsResourcePath sourcePath, DjfsResourcePath destinationPath) {
        super("Destination is subfolder for source: source = `" + sourcePath.getFullPath() + "`, destination = `" +
                destinationPath.getFullPath() + "`");
        this.sourcePath = sourcePath;
        this.destinationPath = destinationPath;
    }
}
