package ru.yandex.chemodan.app.djfs.core.filesystem.iteration;

import ru.yandex.bolts.collection.Option;

/**
 * @author eoshch
 */
public class InMemoryResourceIteratorStateSource implements ResourceIteratorStateSource {
    private ResourceIterator.ResourceIteratorState state;

    @Override
    public void set(ResourceIterator.ResourceIteratorState state) {
        this.state = state;
    }

    @Override
    public Option<ResourceIterator.ResourceIteratorState> get() {
        return Option.ofNullable(state);
    }

    @Override
    public void clear() {
        state = null;
    }
}
