package ru.yandex.chemodan.app.djfs.core.filesystem.model;

import ru.yandex.chemodan.app.djfs.core.StringIntCombinedEnum;
import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author eoshch
 */
public enum AntiVirusScanStatus implements IntEnum, StringIntCombinedEnum {
    CLEAN(1),
    INFECTED(2),
    ERROR(4),
    ;

    private final int value;

    AntiVirusScanStatus(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    @Override
    public int getIntRepresentation() {
        return value();
    }

    @Override
    public String getStringRepresentation() {
        return name().toUpperCase();
    }

    public static final IntEnumResolver<AntiVirusScanStatus> R = IntEnumResolver.r(AntiVirusScanStatus.class);
}
