package ru.yandex.chemodan.app.djfs.core.filesystem.model;

import java.util.HashMap;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.StringArrayEnum;
import ru.yandex.chemodan.app.djfs.core.StringArrayEnumResolver;
import ru.yandex.chemodan.app.djfs.core.user.UserLocale;

public enum DefaultFolder implements StringArrayEnum {
    DOWNLOADS("/disk/Downloads/", "/disk/Загрузки/", "/disk/Завантаження/", "/disk/Downloads/"),
    PHOTOSTREAM("/disk/Camera Uploads/", "/disk/Фотокамера/", "/disk/Фотокамера/", "/disk/Kameradan yüklenenler/"),
    FOTKI("/disk/Yandex.Fotki/", "/disk/Яндекс.Фотки/", "/disk/Яндекс.Фотки/", "/disk/Yandex.Foto/"),
    SCREENSHOTS("/disk/Screenshots/", "/disk/Скриншоты/", "/disk/Скриншоти/", "/disk/Ekran görüntüleri/"),
    SOCIAL("/disk/Social networks/", "/disk/Социальные сети/", "/disk/Соціальні мережі/", "/disk/Sosyal ağlar/"),
    APPLICATIONS("/disk/Applications", "/disk/Приложения", "/disk/Додатки", "/disk/Uygulamalar"),
    YABOOKS("/disk/Yandex.Books", "/disk/Яндекс.Книги", "/disk/Яндекс.Книжки", "/disk/Yandex.Kitaplar"),
    YATEAMNDA("/disk/Yandex Team (NDA)"),
    YAFOTKI("/attach/YaFotki"),

    VKONTAKTE("/disk/Social networks/VK", "/disk/Социальные сети/ВКонтакте", "/disk/Соціальні мережі/ВКонтакте", "/disk/Sosyal ağlar/VK"),
    FACEBOOK("/disk/Social networks/Facebook", "/disk/Социальные сети/Facebook", "/disk/Соціальні мережі/Facebook", "/disk/Sosyal ağlar/Facebook"),
    MAILRU("/disk/Social networks/Мой Мир", "/disk/Социальные сети/Мой Мир", "/disk/Соціальні мережі/Мой Мир", "/disk/Sosyal ağlar/Мой Мир"),
    ODNOKLASSNIKI("/disk/Social networks/Одноклассники", "/disk/Социальные сети/Одноклассники", "/disk/Соціальні мережі/Одноклассники", "/disk/Sosyal ağlar/Одноклассники"),
    GOOGLE("/disk/Social networks/Google+", "/disk/Социальные сети/Google+", "/disk/Соціальні мережі/Google+", "/disk/Sosyal ağlar/Google+"),
    INSTAGRAM("/disk/Social networks/Instagram", "/disk/Социальные сети/Instagram", "/disk/Соціальні мережі/Instagram", "/disk/Sosyal ağlar/Instagram"),

    YASLOVARIARCHIVE("/attach/yaslovariarchive"),
    YARUARCHIVE("/attach/yaruarchive"),
    YALIVELETTERSARCHIVE("/attach/yalivelettersarchive"),
    ARCHIVE("/attach/archive"),
    ATTACH("/disk/Mail attachments", "/disk/Почтовые вложения", "/disk/Поштові вкладення", "/disk/E-posta ekleri"),
    SCANS("/disk/Scans", "/disk/Сканы", "/disk/Скани", "/disk/Tarananlar");

    private String value;
    private HashMap<UserLocale, String> localeNames;

    DefaultFolder(String en, String ru, String uk, String tr) {
        value = name().toLowerCase();
        localeNames = new HashMap<>();
        localeNames.put(UserLocale.EN, en);
        localeNames.put(UserLocale.RU, ru);
        localeNames.put(UserLocale.UK, uk);
        localeNames.put(UserLocale.TR, tr);
    }

    DefaultFolder(String commonPath) {
        this(commonPath, commonPath, commonPath, commonPath);
    }

    @Override
    public String value() {
        return value;
    }

    @Override
    public ListF<String> representations() {
        return Cf.toArrayList(localeNames.values());
    }

    public String pathForLocale(UserLocale userLocale) {
        return localeNames.get(userLocale);
    }

    public static final StringArrayEnumResolver<DefaultFolder> R = StringArrayEnumResolver.r(DefaultFolder.class);
}
