package ru.yandex.chemodan.app.djfs.core.filesystem.model;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author eoshch
 */
public enum DjfsResourceType implements StringEnum {
    FILE,
    DIR,
    ;

    private final String value;

    DjfsResourceType() {
        this.value = name().toLowerCase();
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<DjfsResourceType> R = StringEnumResolver.r(DjfsResourceType.class);
}
