package ru.yandex.chemodan.app.djfs.core.filesystem.model;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author eoshch
 */
public enum FolderType implements StringEnum {
    APPLICATIONS,
    DOWNLOADS,
    GOOGLE,
    FACEBOOK,
    FOTKI,
    MAILRU,
    PHOTOSTREAM,
    SCREENSHOTS,
    SOCIAL,
    INSTAGRAM,
    ODNOKLASSNIKI,
    VKONTAKTE,
    YABOOKS,
    YALIVELETTERSARCHIVE,
    YARUARCHIVE,
    YASLOVARIARCHIVE,
    YATEAMNDA,
    ;

    private final String value;

    FolderType() {
        this.value = name().toLowerCase();
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<FolderType> R = StringEnumResolver.r(FolderType.class);
}
