package ru.yandex.chemodan.app.djfs.core.filesystem.model;

import ru.yandex.chemodan.app.djfs.core.StringIntCombinedEnum;
import ru.yandex.chemodan.app.djfs.core.StringIntCombinedEnumResolver;
import ru.yandex.misc.enums.OrdinalIntEnum;

/**
 * @author eoshch
 */
public enum MediaType implements OrdinalIntEnum, StringIntCombinedEnum {
    AUDIO(0) {
        @Override
        public String getLentaMediaType() {
            return getStringRepresentation();
        }
    },
    BACKUP(1),
    COMPRESSED(2),
    DATA(3),
    DEVELOPMENT(4),
    DISKIMAGE(5),
    DOCUMENT(6) {
        @Override
        public String getLentaMediaType() {
            return getStringRepresentation();
        }
    },
    ENCODED(7),
    FONT(8),
    IMAGE(9) {
        @Override
        public String getLentaMediaType() {
            return getStringRepresentation();
        }
    },
    SETTINGS(10),
    TEXT(11),
    VIDEO(12) {
        @Override
        public String getLentaMediaType() {
            return getStringRepresentation();
        }
    },
    WEB(13),
    EXECUTABLE(14),
    SPREADSHEET(15),
    FLASH(16),
    BOOK(17),
    UNKNOWN(18),
    ;

    private final int value;

    MediaType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    @Override
    public int getIntRepresentation() {
        return value();
    }

    @Override
    public String getStringRepresentation() {
        return name().toLowerCase();
    }

    public String getLentaMediaType() {
        return "other";
    }

    public static final StringIntCombinedEnumResolver<MediaType> R = StringIntCombinedEnumResolver.r(MediaType.class);
}
