package ru.yandex.chemodan.app.djfs.core.filesystem.model.area;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.FormattingContext;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.SharedRights;
import ru.yandex.chemodan.app.djfs.core.share.Group;
import ru.yandex.chemodan.app.djfs.core.share.GroupDao;
import ru.yandex.chemodan.app.djfs.core.share.GroupLink;
import ru.yandex.chemodan.app.djfs.core.share.GroupLinkDao;
import ru.yandex.chemodan.app.djfs.core.share.SharePermissions;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

import static ru.yandex.chemodan.app.djfs.core.legacy.formatting.FolderMetaProvider.SHARED_RIGHTS;
import static ru.yandex.chemodan.app.djfs.core.legacy.formatting.FolderMetaProvider.WITH_SHARED;

public class FolderAreaDiskMetaProvider extends FolderAreaMetaProvider {

    public MapF<String, Object> getFolderSharedMetaData(FolderDjfsResource folder, FormattingContext context,
                                                        GroupDao groupDao, GroupLinkDao groupLinkDao)
    {
        DjfsUid uid = context.getRequestUser().getId();
        ListF<Group> groups = groupDao.findAll(uid);
        boolean isOwner = groups.filter(group -> group.getUid().asLong() == uid.asLong()).map(Group::getPath).exists(folder.getPath()::isParentFor);
        ListF<GroupLink> groupLinks = groupLinkDao.findAll(uid);
        Option<Integer> minSharedRights = groupLinks.filter(groupLink -> groupLink.getUid().asLong() == uid.asLong())
                .filter(groupLink -> folder.getPath().isParentFor(groupLink.getPath()))
                .map(GroupLink::getPermissions).map(SharePermissions::value).minO();
        MapF<String, Object> withShared = Cf.map(WITH_SHARED, 1);
        return minSharedRights.map(sharedRights -> withShared.plus1(SHARED_RIGHTS, SharedRights.withRights(sharedRights)))
                .getOrElse(() -> isOwner ? withShared.plus1(SHARED_RIGHTS, SharedRights.owner()) : Cf.map());
    }
}
