package ru.yandex.chemodan.app.djfs.core.filesystem.model.area;

import com.mongodb.ReadPreference;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.FormattingContext;
import ru.yandex.chemodan.app.djfs.core.share.GroupDao;
import ru.yandex.chemodan.app.djfs.core.share.GroupLinkDao;
import ru.yandex.chemodan.app.djfs.core.user.UserData;

public class FolderAreaMetaProvider {

    public Option<Long> getNumchildren(FolderDjfsResource folder, DjfsResourceDao dao) {
        return Option.of(dao.countImmediateChildren(folder.getPath()));
    }

    public MapF<String, Object> getFolderSharedMetaData(FolderDjfsResource folder, FormattingContext context,
                                                        GroupDao groupDao, GroupLinkDao groupLinkDao,
                                                        Option<ReadPreference> readPreference)
    {
        return Cf.map();
    }

    public Option<Boolean> getIsEmpty(UserData requestUser, FolderDjfsResource folder, Filesystem filesystem,
                                      Option<ReadPreference> readPreference) {
        return Option.empty();
    }
}
