package ru.yandex.chemodan.app.djfs.core.filesystem.model.area;

import com.mongodb.ReadPreference;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsPrincipal;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.user.UserData;

public class FolderAreaTrashMetaProvider extends FolderAreaMetaProvider {

    @Override
    public Option<Long> getNumchildren(FolderDjfsResource folder, DjfsResourceDao dao) {
        return Option.empty();
    }

    @Override
    public Option<Boolean> getIsEmpty(UserData requestUser, FolderDjfsResource folder, Filesystem filesystem,
                                      Option<ReadPreference> readPreference) {
        if (!folder.getPath().isAreaRoot()) {
            return Option.empty();
        }

        return Option.of(filesystem.getChildren(DjfsPrincipal.cons(requestUser), folder, 0, 1, readPreference).isEmpty());
    }
}
