package ru.yandex.chemodan.app.djfs.core.filesystem.model.area;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.client.LogReaderHttpClient;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;

public class ResourceAreaDiskMetaProvider extends ResourceAreaMetaProvider {

    @Override
    public Option<Long> getViewsCounterForResource(DjfsResource resource, LogReaderHttpClient logReaderHttpClient) {
        Option<String> publicHashO = resource.getPublicHash();
        if (!publicHashO.isPresent()) {
            return Option.empty();
        }
        return publicHashO.flatMapO(logReaderHttpClient::getCounter).orElse(Option.of(0L));
    }
}
