package ru.yandex.chemodan.app.djfs.core.filesystem.model.exception;

import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

/**
 * @author eoshch
 */
public class InvalidDjfsResourceAreaException extends InvalidDjfsResourcePathException {
    public InvalidDjfsResourceAreaException(String area, DjfsUid uid, String path) {
        super("Unknown area " + area + ": " + uid + ":" + path);
    }

    public InvalidDjfsResourceAreaException(String area, DjfsUid uid) {
        super("Unknown area " + area + ": " + uid);
    }

    public InvalidDjfsResourceAreaException(String area) {
        super("Unknown area " + area);
    }
}
