package ru.yandex.chemodan.app.djfs.core.filesystem.model.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;

/**
 * @author eoshch
 */
// todo: look at ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel to log as WARN
public class InvalidDjfsResourcePathException extends DjfsException {
    public InvalidDjfsResourcePathException(String message) {
        super(message);
    }

    public InvalidDjfsResourcePathException(long uid, String path) {
        super("uid: " + uid + ", path: " + path);
    }

    public InvalidDjfsResourcePathException(String uid, String path) {
        super("uid: " + uid + ", path: " + path);
    }

    public InvalidDjfsResourcePathException(String message, DjfsResourcePath path) {
        super(message + ": " + path.getFullPath());
    }
}
