package ru.yandex.chemodan.app.djfs.core.filesystem.model.mongo;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.commune.mongo3.MongoBenderParserSerializer;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoResource extends DefaultObject {
    // todo: validation
    public static final MongoBenderParserSerializer<String, MongoResource> B =
            DjfsBenderFactory.createForMongo(MongoResource.class);

    @MongoId
    public String id;
    public String uid;
    public String type;
    public String key;
    public Option<MongoResourceData> data = Option.empty();
    public Option<String> parent = Option.empty();
    public Option<Long> version = Option.empty();
    public Option<byte[]> hid = Option.empty();
    public Option<byte[]> zdata = Option.empty();
    public Option<Integer> dtime = Option.empty();
}
