package ru.yandex.chemodan.app.djfs.core.filesystem.model.mongo;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoResourceData extends DefaultObject {
    public Option<String> mimetype;
    public Option<Integer> mt;
    public Option<Integer> visible;

    @BenderPart(name = "public")
    public Option<Integer> publik;

    public Option<Integer> blocked;
    public Option<Long> size;
    public Option<Integer> utime;
    public Option<Integer> mtime;
    public Option<Long> etime;

    public Option<String> md5;
    public Option<String> sha256;
    public Option<Integer> ctime;

    @BenderPart(wrapperName = "stids")
    public Option<ListF<MongoResourceStid>> stids;

    // todo: use UnderscoreNamesMarshallerUnmarshaller
    @BenderPart(name = "modify_uid", strictName = true)
    public Option<String> modify_uid;

    @BenderPart(name = "file_id", strictName = true)
    public Option<String> file_id;

    @BenderPart(name = "original_id", strictName = true)
    public Option<String> original_id;

    @BenderPart(name = "download_counter", strictName = true)
    public Option<Integer> download_counter;

    public MongoResourceData() {
        mimetype = Option.empty();
        mt = Option.empty();
        visible = Option.empty();
        publik = Option.empty();
        blocked = Option.empty();
        size = Option.empty();
        utime = Option.empty();
        mtime = Option.empty();
        etime = Option.empty();
        stids = Option.empty();
        modify_uid = Option.empty();
        file_id = Option.empty();
        original_id = Option.empty();
        download_counter = Option.empty();

        md5 = Option.empty();
        sha256 = Option.empty();
        ctime = Option.empty();
    }
}
