package ru.yandex.chemodan.app.djfs.core.filesystem.model.mongo;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author eoshch
 */
@BenderBindAllFields
public class MongoResourceZData extends DefaultObject {
    public static final BenderParserSerializer<MongoResourceZData> B =
            DjfsBenderFactory.createForJson(MongoResourceZData.class);

    public Option<MongoResourceMeta> meta;
    public Option<MongoResourceSetprop> setprop;
    public Option<MongoResourcePub> pub;

    public MongoResourceZData() {
        meta = Option.empty();
        setprop = Option.empty();
        pub = Option.empty();
    }

    public boolean isPresent() {
        return (meta != null && meta.isPresent()) || (setprop != null && setprop.isPresent())
                || (pub != null && pub.isPresent());
    }
}
