package ru.yandex.chemodan.app.djfs.core.filesystem.model.mongo.parsing;

import org.bson.BsonDocument;

import ru.yandex.bolts.internal.NotImplementedException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceArea;

/**
 * @author eoshch
 */
public class ResourceFactory2 extends MongoFactoryBase {
    public static DjfsResource create(DjfsResourceArea area, BsonDocument document) {
        String type = getString("type", document);
        switch (type) {
            case "file":
                return MongoFileDjfsResourceParser.create(document);
            case "dir":
                return MongoFolderDjfsResourceParser.create(area, document);
            default:
                throw new NotImplementedException();
        }
    }
}
