package ru.yandex.chemodan.app.djfs.core.filesystem.operation;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.filesystem.FilesystemAccessController;
import ru.yandex.chemodan.app.djfs.core.filesystem.OperationCallbackHandler;
import ru.yandex.chemodan.app.djfs.core.filesystem.QuotaManager;
import ru.yandex.chemodan.app.djfs.core.filesystem.iteration.ResourceIterator;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.copy.CopyOperationHandler;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.copy.CopyOperationProperties;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.move.MoveOperationHandler;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.postprocess.QuickMovePostProcessTaskProperties;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.postprocess.QuickMovePostProcessTaskSubmitter;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.postprocess.TrashAreaPostProcessor;
import ru.yandex.chemodan.app.djfs.core.filesystem.operation.trashappend.TrashAppendOperationHandler;
import ru.yandex.chemodan.app.djfs.core.globalgallery.DeletionLogDao;
import ru.yandex.chemodan.app.djfs.core.history.EventHistoryLogger;
import ru.yandex.chemodan.app.djfs.core.legacy.web.LegacyMpfsExceptionHandler;
import ru.yandex.chemodan.app.djfs.core.lock.LockManager;
import ru.yandex.chemodan.app.djfs.core.operations.MpfsOperationHandlerContext;
import ru.yandex.chemodan.app.djfs.core.operations.MpfsOperationHandlerProperties;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfoManager;
import ru.yandex.chemodan.app.djfs.core.user.UserDao;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorage;

/**
 * @author eoshch
 */
@Configuration
public class FilesystemOperationContextConfiguration {
    @Bean
    public MpfsOperationHandlerContext mpfsOperationHandlerContext(OperationDao operationDao,
            MpfsOperationHandlerProperties mpfsOperationHandlerProperties)
    {
        return new MpfsOperationHandlerContext(operationDao, mpfsOperationHandlerProperties);
    }

    @Bean
    public CopyOperationProperties copyOperationProperties() {
        return new CopyOperationProperties();
    }

    @Bean
    public CopyOperationHandler copyOperationHandler(MpfsOperationHandlerContext mpfsOperationHandlerContext,
            CopyOperationProperties copyOperationProperties, DjfsResourceDao djfsResourceDao, Filesystem filesystem,
            LockManager lockManager, ShareInfoManager shareInfoManager, UserDao userDao,
            ResourceIterator.Factory ressourceIteratorFactory, EventHistoryLogger eventHistoryLogger,
            QuotaManager quotaManager, FilesystemAccessController filesystemAccessController)
    {
        return new CopyOperationHandler(mpfsOperationHandlerContext, copyOperationProperties, djfsResourceDao,
                filesystem, lockManager, shareInfoManager, userDao, ressourceIteratorFactory, eventHistoryLogger,
                quotaManager, filesystemAccessController);
    }

    @Bean
    public MoveOperationHandler moveOperationHandler(MpfsOperationHandlerContext mpfsOperationHandlerContext,
            Filesystem filesystem, EventHistoryLogger eventHistoryLogger,
            OperationCallbackHandler operationCallbackHandler, LegacyMpfsExceptionHandler legacyMpfsExceptionHandler)
    {
        return new MoveOperationHandler(mpfsOperationHandlerContext, filesystem, eventHistoryLogger,
                operationCallbackHandler, legacyMpfsExceptionHandler);
    }

    @Bean
    public TrashAppendOperationHandler trashAppendOperationHandler(
            MpfsOperationHandlerContext mpfsOperationHandlerContext,
            Filesystem filesystem, EventHistoryLogger eventHistoryLogger,
            OperationCallbackHandler operationCallbackHandler, LegacyMpfsExceptionHandler legacyMpfsExceptionHandler)
    {
        return new TrashAppendOperationHandler(mpfsOperationHandlerContext, filesystem, eventHistoryLogger,
                operationCallbackHandler, legacyMpfsExceptionHandler);
    }

    @Bean
    public QuickMovePostProcessTaskProperties quickMovePostProcessOperationProperties() {
        return new QuickMovePostProcessTaskProperties();
    }

    @Bean
    public QuickMovePostProcessTaskSubmitter quickMovePostProcessTaskSubmitter(
            QuickMovePostProcessTaskProperties properties, BazingaTaskManager bazingaTaskManager,
            PgBazingaStorage pgBazingaStorage)
    {
        return new QuickMovePostProcessTaskSubmitter(properties, bazingaTaskManager, pgBazingaStorage);
    }

    @Bean
    public TrashAreaPostProcessor trashAreaPostProcessor(
            DeletionLogDao deletionLogDao, DjfsResourceDao djfsResourceDao,
            CeleryTaskManager celeryTaskManager)
    {
        return new TrashAreaPostProcessor(deletionLogDao, djfsResourceDao, celeryTaskManager);
    }
}
