package ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.djfs.core.filesystem.AlbumAppendActivity;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.history.EventHistoryLogger;

public class AlbumAppendCallbacks {
    private ListF<Function1V<DjfsResource>> afterAlbumAppendInsideTransactionCallbacks;
    private ListF<Function1V<AlbumAppendActivity>> afterAlbumAppendOutsideTransactionCallbacks;

    private AlbumAppendCallbacks() {
        afterAlbumAppendInsideTransactionCallbacks = Cf.arrayList();
        afterAlbumAppendOutsideTransactionCallbacks = Cf.arrayList();
    }

    public static ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks empty() { return new ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks(); }

    public static ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks defaultWithLogging(EventHistoryLogger eventHistoryLogger) {
        return new ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks().appendAfterAlbumAppendOutsideTransactionCallback(eventHistoryLogger::log);
    }

    public void callAfterAlbumAppendInsideTransaction(DjfsResource appendedResource) {
        for (Function1V<DjfsResource> callback : afterAlbumAppendInsideTransactionCallbacks) {
            callback.apply(appendedResource);
        }
    }

    public void callAfterAlbumAppendOutsideTransaction(AlbumAppendActivity activity) {
        for (Function1V<AlbumAppendActivity> callback : afterAlbumAppendOutsideTransactionCallbacks) {
            callback.apply(activity);
        }
    }

    private ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks makeCopy() {
        ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks copy = new ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks();
        copy.afterAlbumAppendInsideTransactionCallbacks = Cf.toArrayList(afterAlbumAppendInsideTransactionCallbacks);
        copy.afterAlbumAppendOutsideTransactionCallbacks = Cf.toArrayList(afterAlbumAppendOutsideTransactionCallbacks);
        return copy;
    }

    public ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks appendAfterAlbumAppendInsideTransactionCallback(Function1V<DjfsResource> callback) {
        ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks copy = makeCopy();
        copy.afterAlbumAppendInsideTransactionCallbacks.add(callback);
        return copy;
    }

    public ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks appendAfterAlbumAppendOutsideTransactionCallback(Function1V<AlbumAppendActivity> callback) {
        ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumappend.AlbumAppendCallbacks copy = makeCopy();
        copy.afterAlbumAppendOutsideTransactionCallbacks.add(callback);
        return copy;
    }
}
