package ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumitemremove;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.djfs.core.filesystem.AlbumItemRemoveActivity;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.history.EventHistoryLogger;

public class AlbumItemRemoveCallbacks {
    private ListF<Function1V<DjfsResource>> afterAlbumItemRemoveInsideTransactionCallbacks;
    private ListF<Function1V<AlbumItemRemoveActivity>> afterAlbumItemRemoveOutsideTransactionCallbacks;

    private AlbumItemRemoveCallbacks() {
        afterAlbumItemRemoveInsideTransactionCallbacks = Cf.arrayList();
        afterAlbumItemRemoveOutsideTransactionCallbacks = Cf.arrayList();
    }

    public static AlbumItemRemoveCallbacks empty() { return new AlbumItemRemoveCallbacks(); }

    public static AlbumItemRemoveCallbacks defaultWithLogging(EventHistoryLogger eventHistoryLogger) {
        return new AlbumItemRemoveCallbacks().appendAfterAlbumItemRemoveOutsideTransactionCallback(eventHistoryLogger::log);
    }

    public void callAfterAlbumItemRemoveInsideTransaction(DjfsResource removedResource) {
        for (Function1V<DjfsResource> callback : afterAlbumItemRemoveInsideTransactionCallbacks) {
            callback.apply(removedResource);
        }
    }

    public void callAfterAlbumItemRemoveOutsideTransaction(AlbumItemRemoveActivity activity) {
        for (Function1V<AlbumItemRemoveActivity> callback : afterAlbumItemRemoveOutsideTransactionCallbacks) {
            callback.apply(activity);
        }
    }

    private AlbumItemRemoveCallbacks makeCopy() {
        AlbumItemRemoveCallbacks copy = new AlbumItemRemoveCallbacks();
        copy.afterAlbumItemRemoveInsideTransactionCallbacks = Cf.toArrayList(afterAlbumItemRemoveInsideTransactionCallbacks);
        copy.afterAlbumItemRemoveOutsideTransactionCallbacks = Cf.toArrayList(afterAlbumItemRemoveOutsideTransactionCallbacks);
        return copy;
    }

    public AlbumItemRemoveCallbacks appendAfterAlbumItemRemoveInsideTransactionCallback(Function1V<DjfsResource> callback) {
        AlbumItemRemoveCallbacks copy = makeCopy();
        copy.afterAlbumItemRemoveInsideTransactionCallbacks.add(callback);
        return copy;
    }

    public AlbumItemRemoveCallbacks appendAfterAlbumItemRemoveOutsideTransactionCallback(Function1V<AlbumItemRemoveActivity> callback) {
        AlbumItemRemoveCallbacks copy = makeCopy();
        copy.afterAlbumItemRemoveOutsideTransactionCallbacks.add(callback);
        return copy;
    }
}
