package ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumremove;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.djfs.core.filesystem.AlbumRemoveActivity;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.history.EventHistoryLogger;

public class AlbumRemoveCallbacks {
    private ListF<Function1V<DjfsResource>> afterAlbumRemoveInsideTransactionCallbacks;
    private ListF<Function1V<AlbumRemoveActivity>> afterAlbumRemoveOutsideTransactionCallbacks;

    private AlbumRemoveCallbacks() {
        afterAlbumRemoveInsideTransactionCallbacks = Cf.arrayList();
        afterAlbumRemoveOutsideTransactionCallbacks = Cf.arrayList();
    }

    public static AlbumRemoveCallbacks empty() { return new AlbumRemoveCallbacks(); }

    public static AlbumRemoveCallbacks defaultWithLogging(EventHistoryLogger eventHistoryLogger) {
        return new AlbumRemoveCallbacks().appendAfterAlbumItemRemoveOutsideTransactionCallback(eventHistoryLogger::log);
    }

    public void callAfterAlbumRemoveInsideTransaction(DjfsResource removedResource) {
        for (Function1V<DjfsResource> callback : afterAlbumRemoveInsideTransactionCallbacks) {
            callback.apply(removedResource);
        }
    }

    public void callAfterAlbumRemoveOutsideTransaction(AlbumRemoveActivity activity) {
        for (Function1V<AlbumRemoveActivity> callback : afterAlbumRemoveOutsideTransactionCallbacks) {
            callback.apply(activity);
        }
    }

    private AlbumRemoveCallbacks makeCopy() {
        AlbumRemoveCallbacks copy = new AlbumRemoveCallbacks();
        copy.afterAlbumRemoveInsideTransactionCallbacks = Cf.toArrayList(afterAlbumRemoveInsideTransactionCallbacks);
        copy.afterAlbumRemoveOutsideTransactionCallbacks = Cf.toArrayList(afterAlbumRemoveOutsideTransactionCallbacks);
        return copy;
    }

    public AlbumRemoveCallbacks appendAfterAlbumRemoveInsideTransactionCallback(Function1V<DjfsResource> callback) {
        AlbumRemoveCallbacks copy = makeCopy();
        copy.afterAlbumRemoveInsideTransactionCallbacks.add(callback);
        return copy;
    }

    public AlbumRemoveCallbacks appendAfterAlbumItemRemoveOutsideTransactionCallback(Function1V<AlbumRemoveActivity> callback) {
        AlbumRemoveCallbacks copy = makeCopy();
        copy.afterAlbumRemoveOutsideTransactionCallbacks.add(callback);
        return copy;
    }
}
