package ru.yandex.chemodan.app.djfs.core.filesystem.operation.albumsetattr;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.djfs.core.filesystem.AlbumSetAttrActivity;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.history.EventHistoryLogger;

public class AlbumSetAttrCallbacks {
    private ListF<Function1V<DjfsResource>> afterAlbumSetAttrInsideTransactionCallbacks;
    private ListF<Function1V<AlbumSetAttrActivity>> afterAlbumSetAttrOutsideTransactionCallbacks;

    private AlbumSetAttrCallbacks() {
        afterAlbumSetAttrInsideTransactionCallbacks = Cf.arrayList();
        afterAlbumSetAttrOutsideTransactionCallbacks = Cf.arrayList();
    }

    public static AlbumSetAttrCallbacks empty() { return new AlbumSetAttrCallbacks(); }

    public static AlbumSetAttrCallbacks defaultWithLogging(EventHistoryLogger eventHistoryLogger) {
        return new AlbumSetAttrCallbacks().appendAfterAlbumSetAttrOutsideTransactionCallback(eventHistoryLogger::log);
    }

    public void callAfterAlbumSetAttrInsideTransaction(DjfsResource appendedResource) {
        for (Function1V<DjfsResource> callback : afterAlbumSetAttrInsideTransactionCallbacks) {
            callback.apply(appendedResource);
        }
    }

    public void callAfterAlbumSetAttrOutsideTransaction(AlbumSetAttrActivity activity) {
        for (Function1V<AlbumSetAttrActivity> callback : afterAlbumSetAttrOutsideTransactionCallbacks) {
            callback.apply(activity);
        }
    }

    public AlbumSetAttrCallbacks makeCopy() {
        AlbumSetAttrCallbacks copy = new AlbumSetAttrCallbacks();
        copy.afterAlbumSetAttrInsideTransactionCallbacks = Cf.toArrayList(afterAlbumSetAttrInsideTransactionCallbacks);
        copy.afterAlbumSetAttrOutsideTransactionCallbacks = Cf.toArrayList(afterAlbumSetAttrOutsideTransactionCallbacks);
        return copy;
    }

    public AlbumSetAttrCallbacks appendAfterAlbumSetAttrOutsideTransactionCallback(Function1V<AlbumSetAttrActivity> callback) {
        AlbumSetAttrCallbacks copy = makeCopy();
        copy.afterAlbumSetAttrOutsideTransactionCallbacks.add(callback);
        return copy;
    }

    public AlbumSetAttrCallbacks appendAfterAlbumAppendInsideTransactionCallback(Function1V<DjfsResource> callback) {
        AlbumSetAttrCallbacks copy = makeCopy();
        copy.afterAlbumSetAttrInsideTransactionCallbacks.add(callback);
        return copy;
    }
}
