package ru.yandex.chemodan.app.djfs.core.filesystem.operation.copy;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.bazinga.impl.TaskId;

/**
 * @author eoshch
 */
public abstract class CopyOperation {
    public static final TaskId TASK_ID =
            new TaskId("mpfs.core.job_handlers.operation.handle_filesystem_copy_operation");

    public static final String TYPE = "copy";
    public static final String SUBTYPE = "copy";

    public static Operation create(DjfsUid uid, DjfsResourcePath source, DjfsResourcePath destination) {
        return Operation.cons(uid, TYPE, SUBTYPE, CopyOperationData.builder()
                .source(source.getFullPath())
                .destination(destination.getFullPath())
                .build(), CopyOperationData.B);
    }
}
