package ru.yandex.chemodan.app.djfs.core.filesystem.operation.copy;

import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.filesystem.iteration.ResourceIterator;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author eoshch
 */
@Value
@Builder(toBuilder = true)
@BenderBindAllFields
public class CopyOperationData {
    public static final BenderParserSerializer<CopyOperationData> B =
            DjfsBenderFactory.createForJson(CopyOperationData.class);

    private final String source;
    private final String destination;

    @BenderPart(name = "connection_id", strictName = true)
    @Builder.Default
    private final Option<String> connectionId = Option.empty();

    @Builder.Default
    private final Option<String> currentSharedFolderId = Option.empty();

    @Builder.Default
    private final Option<ResourceIterator.ResourceIteratorState> state = Option.empty();

    @Builder.Default
    private final Option<Operation.ErrorData> error = Option.empty();
}
