package ru.yandex.chemodan.app.djfs.core.filesystem.operation.move;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.djfs.core.filesystem.MoveActivity;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.history.EventHistoryLogger;


public class MoveCallbacks {
    private ListF<Function1V<DjfsResource>> afterMoveInsideTransactionCallbacks;
    private ListF<Function1V<MoveActivity>> afterMoveOutsideTransactionCallbacks;

    private MoveCallbacks() {
        afterMoveInsideTransactionCallbacks = Cf.arrayList();
        afterMoveOutsideTransactionCallbacks = Cf.arrayList();
    }

    public static MoveCallbacks empty() {
        return new MoveCallbacks();
    }

    public static MoveCallbacks defaultWithLogging(EventHistoryLogger eventHistoryLogger) {
        return new MoveCallbacks().appendAfterMoveOutsideTransactionCallback(eventHistoryLogger::log);
    }

    public void callAfterMoveInsideTransaction(DjfsResource removedResource) {
        for (Function1V<DjfsResource> callback : afterMoveInsideTransactionCallbacks) {
            callback.apply(removedResource);
        }
    }

    public void callAfterMoveOutsideTransaction(MoveActivity activity) {
        for (Function1V<MoveActivity> callback : afterMoveOutsideTransactionCallbacks) {
            callback.apply(activity);
        }
    }

    private MoveCallbacks makeCopy() {
        MoveCallbacks copy = new MoveCallbacks();
        copy.afterMoveInsideTransactionCallbacks = Cf.toArrayList(afterMoveInsideTransactionCallbacks);
        copy.afterMoveOutsideTransactionCallbacks = Cf.toArrayList(afterMoveOutsideTransactionCallbacks);
        return copy;
    }

    public MoveCallbacks appendAfterMoveInsideTransactionCallback(Function1V<DjfsResource> callback) {
        MoveCallbacks copy = makeCopy();
        copy.afterMoveInsideTransactionCallbacks.add(callback);
        return copy;
    }

    public MoveCallbacks appendAfterMoveOutsideTransactionCallback(Function1V<MoveActivity> callback) {
        MoveCallbacks copy = makeCopy();
        copy.afterMoveOutsideTransactionCallbacks.add(callback);
        return copy;
    }
}
