package ru.yandex.chemodan.app.djfs.core.filesystem.operation.move;

import java.util.UUID;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.UuidUtils;
import ru.yandex.chemodan.app.djfs.core.web.ConnectionIdHolder;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.misc.digest.Md5;

public  abstract class MoveOperation {
    public static final TaskId TASK_ID =
            new TaskId("mpfs.core.job_handlers.operation.handle_filesystem_move_operation");

    public static Operation create(DjfsUid uid, DjfsResourcePath sourcePath, DjfsResource resource,
            DjfsResourcePath destinationPath, boolean force, String callback, long userDiskVersion)
    {
        String operationSubtype = String.format("%s_%s", sourcePath.getArea().value(), destinationPath.getArea().value());

        Md5.Sum operationParamsDigest =
                Md5.A.digest(uid.asString() + "move" + sourcePath.getFullPath() + destinationPath.getFullPath());
        UUID operationUniqId = UuidUtils.from(operationParamsDigest.getBytes());

        MoveOperationData data = MoveOperationData.builder()
                .sourceFullPath(sourcePath.getFullPath())
                .destinationFullPath(destinationPath.getFullPath())
                .force(force ? 1 : 0)
                .callback(callback)
                .connectionId(ConnectionIdHolder.getO().getOrElse(""))
                .sourceResourceId(resource.getResourceId().map(DjfsResourceId::getValue).getOrElse(""))
                .fileId(resource.getResourceId().map(x -> x.getFileId().getValue()).getOrElse(""))
                .atVersion(userDiskVersion)
                .build();

        Operation operation = Operation.cons(uid, "move", operationSubtype, data, MoveOperationData.B)
                .withUniqueId(operationUniqId);
        return operation.toBuilder().state(Operation.State.WAITING).build();
    }
}
