package ru.yandex.chemodan.app.djfs.core.filesystem.operation.postprocess;

import lombok.RequiredArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceArea;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.impl.JobStatus;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.pg.storage.PgBazingaStorage;


@RequiredArgsConstructor
public class QuickMovePostProcessTaskSubmitter {

    private final QuickMovePostProcessTaskProperties properties;
    private final BazingaTaskManager bazingaTaskManager;
    private final PgBazingaStorage pgBazingaStorage;

    public void checkLimitAndSchedule(DjfsResourcePath path) {
        QuickMovePostProcessTask task = new QuickMovePostProcessTask(path);

        int userTasksCount = countUserTasks(task.id(), path.getUid(), path.getArea());
        if (userTasksCount > properties.getUserTaskLimit()) {
            throw new PostProcessTaskLimitExceededException(
                    "User " + path.getUid().asString() + " exceeded post process task limit (" + userTasksCount + "/" +
                            properties.getUserTaskLimit() + ")"
            );
        }

        bazingaTaskManager.schedule(task);
    }

    public void schedule(DjfsResourcePath path, Instant date) {
        QuickMovePostProcessTask task = new QuickMovePostProcessTask(path);
        bazingaTaskManager.schedule(task, date);
    }

    public int countRunningTasks(TaskId id, DjfsUid uid, DjfsResourceArea area) {
        String key = QuickMovePostProcessTask.formatIndexKey(uid, area);
        return pgBazingaStorage.countByTaskAndParamsWithStatuses(
                id, Cf.map("index_key", key), Cf.list(JobStatus.RUNNING));
    }

    public int countUserTasks(TaskId id, DjfsUid uid, DjfsResourceArea area) {
        String key = QuickMovePostProcessTask.formatIndexKey(uid, area);
        return pgBazingaStorage.countByTaskAndParamsWithStatuses(
                id, Cf.map("index_key", key), Cf.list(JobStatus.READY, JobStatus.STARTING, JobStatus.RUNNING));
    }
}
