package ru.yandex.chemodan.app.djfs.core.filesystem.operation.trashappend;

import java.util.UUID;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.UuidUtils;
import ru.yandex.chemodan.app.djfs.core.web.ConnectionIdHolder;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.misc.digest.Md5;

public class TrashAppendOperation {
    public static final TaskId TASK_ID =
            new TaskId("mpfs.core.job_handlers.operation.handle_filesystem_trash_append_operation");

    public static Operation create(DjfsUid uid, DjfsResourcePath path, DjfsResource resource,
            String callback, long userDiskVersion)
    {
        Md5.Sum operationParamsDigest = Md5.A.digest(uid.asString() + "trash" + path.getFullPath());
        UUID operationUniqId = UuidUtils.from(operationParamsDigest.getBytes());

        TrashAppendOperationData data = TrashAppendOperationData.builder()
                .path(path.getFullPath())
                .callback(callback)
                .connectionId(ConnectionIdHolder.getO().getOrElse(""))
                .sourceResourceId(resource.getResourceId().map(DjfsResourceId::getValue).getOrElse(""))
                .fileId(resource.getResourceId().map(x -> x.getFileId().getValue()).getOrElse(""))
                .atVersion(userDiskVersion)
                .build();

        Operation operation = Operation.cons(uid, "trash", "append", data, TrashAppendOperationData.B)
                .withUniqueId(operationUniqId);

        return operation.toBuilder().state(Operation.State.WAITING).build();
    }
}
