package ru.yandex.chemodan.app.djfs.core.filesystem.operation.trashappend;


import lombok.Builder;
import lombok.Value;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.db.mongo.DjfsBenderFactory;
import ru.yandex.chemodan.app.djfs.core.operations.Operation;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;


@Value
@Builder(toBuilder = true)
@BenderBindAllFields
public class TrashAppendOperationData {
    public static final BenderParserSerializer<TrashAppendOperationData> B =
            DjfsBenderFactory.createForJson(TrashAppendOperationData.class);

    @BenderPart(name = "path", strictName = true)
    private final String path;
    private final String callback;
    @BenderPart(name = "connection_id", strictName = true)
    private final String connectionId;
    @BenderPart(name = "source_resource_id", strictName = true)
    private final String sourceResourceId;
    @BenderPart(name = "file_id", strictName = true)
    private final String fileId;
    @BenderPart(name = "at_version", strictName = true)
    private final Long atVersion;

    @BenderPart(name = "affected_resource", strictName = true)
    @Builder.Default
    private final Option<String> affectedResource = Option.empty();

    @Builder.Default
    private final Option<Operation.ErrorData> error = Option.empty();
}
