package ru.yandex.chemodan.app.djfs.core.globalgallery;


import java.util.UUID;

import lombok.Builder;
import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.djfs.core.db.DjfsUidSource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsFileId;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;

@Value
@Builder(toBuilder = true)
public class DeletionLogEntry implements DjfsUidSource {
    private final DjfsUid uid;
    private final DjfsFileId fileId;
    private final UUID storageId;
    @Builder.Default
    private final Instant revision = Instant.now();
    private final boolean isLivePhoto;
}
