package ru.yandex.chemodan.app.djfs.core.globalgallery;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.DjfsDbContextConfiguration;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;

@Configuration
@Import({
        DjfsDbContextConfiguration.class,
})
public class GlobalGalleryContextConfiguration {
    @Bean
    public PgDeletionLogDao pgDeletionLogDao(PgShardedDaoContext dependencies) {
        return new PgDeletionLogDao(dependencies);
    }

    @Bean
    @Primary
    public DeletionLogDao deletionLogDaoProxy(DaoProxyFactory daoProxyFactory, PgDeletionLogDao pgDao) {
        return daoProxyFactory.create(
                DeletionLogDao.class,
            pgDao
        );
    }
}

