package ru.yandex.chemodan.app.djfs.core.index;

import java.util.concurrent.ExecutorService;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.djfs.core.client.DiskSearchHttpClient;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfoManager;
import ru.yandex.chemodan.app.djfs.core.user.UserDao;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author eoshch
 */
@Configuration
public class IndexContextConfiguration {
    @Bean
    public SearchPushGeneratorProperties searchPushGeneratorProperties() {
        return new SearchPushGeneratorProperties();
    }

    @Bean
    public SearchPushGenerator searchPushGenerator(ExecutorService executorService, CeleryTaskManager celeryTaskManager,
            UserDao userDao, SearchPushGeneratorProperties searchPushGeneratorProperties)
    {
        return new SearchPushGenerator(executorService, celeryTaskManager, userDao, searchPushGeneratorProperties);
    }

    @Bean
    public BazingaManagerProperties bazingaTaskManagerProperties() {
        return new BazingaManagerProperties();
    }

    @Bean
    public IndexerActions indexerActions(Filesystem filesystem, ShareInfoManager shareInfoManager, UserDao userDao,
            BazingaTaskManager bazingaTaskManager, BazingaManagerProperties bazingaTaskManagerProperties, IndexerManager indexerManager)
    {
        return new IndexerActions(filesystem, shareInfoManager, userDao, bazingaTaskManager, bazingaTaskManagerProperties, indexerManager);
    }

    @Bean
    public IndexerManager indexerManager(Filesystem filesystem, DiskSearchHttpClient diskSearchHttpClient,
            UserDao userDao)
    {
        return new IndexerManager(filesystem, diskSearchHttpClient, userDao);
    }
}
