package ru.yandex.chemodan.app.djfs.core.index;


import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.geo.Coordinates;


@BenderBindAllFields
@Data
public class IndexerBinaryData {
    @BenderPart(name = "id", strictName = true)
    private final String fileId;
    private final Option<Integer> width;
    private final Option<Integer> height;
    private final Option<String> orientation;
    private final Option<Double> latitude;
    private final Option<Double> longitude;

    private static final StringEnumResolver<IndexerOrientation> R = StringEnumResolver.r(IndexerOrientation.class);

    public Option<Integer> getWidth() {
        if (width.isPresent()
                && width.get() > 0) {
            return width;
        }
        return Option.empty();
    }

    public Option<Integer> getHeight() {
        if (height.isPresent()
                && height.get() > 0) {
            return height;
        }
        return Option.empty();
    }

    public Option<IndexerOrientation> getOrientation() {
        if (orientation.isPresent()) {
            try {
                return Option.of(R.valueOf(orientation.get()));
            } catch (IllegalArgumentException e) {
                return Option.empty();
            }
        }
        return Option.empty();
    }

    public Option<Coordinates> getCoordinates() {
        if (latitude.isPresent() && longitude.isPresent()) {
            return Option.of(new Coordinates(latitude.get(), longitude.get()));
        }
        return Option.empty();
    }
}
