package ru.yandex.chemodan.app.djfs.core.index;

import java.util.UUID;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.MediaTypeResolver;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FileDjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.MediaType;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.PhotosliceAlbumType;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.chemodan.app.djfs.core.util.UuidUtils;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@ActionResultPojo
@BenderBindAllFields
public class IndexerFilePojo extends IndexerResourcePojo {
    public final String stid;
    public final String md5;
    public final long size;

    @BenderPart(name = "mtime", strictName = true)
    public final long modificationTime;
    @BenderPart(name = "ctime", strictName = true)
    public final long creationTime;
    @BenderPart(name = "etime", strictName = true)
    public final Option<Long> exifTime;

    @BenderPart(name = "mimetype", strictName = true)
    public final Option<String> mimetype;
    @BenderPart(name = "media_type", strictName = true)
    public final String mediaType;
    @BenderPart(name = "external_url", strictName = true)
    public final Option<String> externalUrl;
    @BenderPart(name = "photoslice_time", strictName = true)
    public final Option<Long> photosliceTime;
    @BenderPart(name = "fotki_tags", strictName = true)
    public final Option<String> fotkiTags;
    @BenderPart(name = "preview_stid", strictName = true)
    public final Option<String> previewStid;
    @BenderPart(name = "parent_fid", strictName = true)
    public final String parentFid;
    @BenderPart(name = "photoslice_album_type", strictName = true)
    public final Option<String> photosliceAlbumType;
    @BenderPart(name = "albums_exclusions", strictName = true)
    public final Option<ListF<String>> albumsExclusions;

    public IndexerFilePojo(DjfsUid requestUid, FileDjfsResource resource, UUID parentId,
            Option<ShareInfo> shareInfo) {
        super(requestUid, resource, shareInfo);
        stid = resource.getFileStid();
        md5 = resource.getMd5();
        size = resource.getSize();
        modificationTime = InstantUtils.toSecondsLong(resource.getModificationTime());
        creationTime = InstantUtils.toSecondsLong(resource.getCreationTime());
        mimetype = resource.getMimetype();
        mediaType = resource.getMediaType().orElse(MediaTypeResolver.resolve(resource.getPath(), resource.getMimetype()))
                .map(MediaType::getStringRepresentation).getOrElse("unknown");
        externalUrl = resource.getExternalUrl();
        photosliceTime = resource.getPhotosliceTime().map(InstantUtils::toSecondsLong);
        Option<String> fotkiTagsLocal = resource.getFotkiTags().map(x -> x.replace(",", "\n"));
        // Don't add exifTime if fotkiTags is presented because we don't want to show files from Ya.Fotki (Archive) in photoslice after migration.
        if (!fotkiTagsLocal.isPresent()) {
            exifTime = resource.getExifTime().map(InstantUtils::toSecondsLong);
        } else {
            exifTime = Option.empty();
        }
        if (fotkiTagsLocal.map(String::isEmpty).getOrElse(false)) {
            fotkiTagsLocal = Option.empty();
        }
        fotkiTags = fotkiTagsLocal;
        previewStid = resource.getPreviewStid();

        parentFid = UuidUtils.toHexString(parentId);

        photosliceAlbumType = resource.getPhotosliceAlbumType().map(PhotosliceAlbumType::value);

        albumsExclusions = resource.getAlbumsExclusions();
    }
}
