package ru.yandex.chemodan.app.djfs.core.index;

import java.util.UUID;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderDjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.FolderType;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfo;
import ru.yandex.chemodan.app.djfs.core.user.DjfsUid;
import ru.yandex.chemodan.app.djfs.core.util.InstantUtils;
import ru.yandex.chemodan.app.djfs.core.util.UuidUtils;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@ActionResultPojo
@BenderBindAllFields
public class IndexerFolderPojo extends IndexerResourcePojo {
    @BenderPart(name = "mtime", strictName = true)
    public final Option<Long> modificationTime;
    @BenderPart(name = "ctime", strictName = true)
    public final Option<Long> creationTime;
    @BenderPart(name = "folder_type", strictName = true)
    public final Option<String> folderType;
    @BenderPart(name = "shared_folder_owner", strictName = true)
    public final Option<String> sharedFolderOwner;
    @BenderPart(name = "fid", strictName = true)
    public final String fid;
    @BenderPart(name = "parent_fids", strictName = true)
    public final ListF<String> parentFids;

    public IndexerFolderPojo(DjfsUid requestUid, FolderDjfsResource resource, ListF<UUID> parentIds,
            Option<ShareInfo> shareInfo) {
        super(requestUid, resource, shareInfo);
        modificationTime = resource.getModificationTime().map(InstantUtils::toSecondsLong);
        creationTime = resource.getCreationTime().map(InstantUtils::toSecondsLong);
        folderType = resource.getFolderType().map(FolderType::name).map(String::toLowerCase);
        sharedFolderOwner = shareInfo.map(ShareInfo::getOwnerUid).map(DjfsUid::asString);
        fid = UuidUtils.toHexString(resource.getId());
        if (parentIds.isEmpty()) {
            this.parentFids = Cf.list();
        } else {
            this.parentFids = parentIds.subList(1, parentIds.length()).map(UuidUtils::toHexString);
        }
    }
}
