package ru.yandex.chemodan.app.djfs.core.index;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourceId;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author eoshch
 */
public class IndexerGetResourceNoRelevantResourceException extends DjfsException implements HttpStatusCodeSource {

    public IndexerGetResourceNoRelevantResourceException(DjfsResourceId resourceId, long version,
            ListF<DjfsResource> foundResources)
    {
        super("resourceId=" + resourceId.toString()
                + " version=" + version
                + " found: ["
                + StringUtils.join(foundResources.map(x ->
                "path=" + x.getPath().getFullPath() + " version=" + x.getVersion()), ", ")
                + "]");
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_500_INTERNAL_SERVER_ERROR;
    }
}
