package ru.yandex.chemodan.app.djfs.core.index;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;

public class IndexerInvalidFileIdException extends DjfsException implements HttpStatusCodeSource {
    public IndexerInvalidFileIdException(String fileId) {
        super("id in body differs from query param: " + fileId);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_400_BAD_REQUEST;
    }
}
