package ru.yandex.chemodan.app.djfs.core.index;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResource;

public class UnableToBuildResponseFromResourceException extends DjfsException {
    public final DjfsResource resource;

    public UnableToBuildResponseFromResourceException(DjfsResource resource) {
        super("Unable to build response from resource " + resource.getId());
        this.resource = resource;
    }

    public UnableToBuildResponseFromResourceException(DjfsResource resource, String message) {
        super("Unable to build response from resource " + resource.getId() + " : " + message);
        this.resource = resource;
    }
}

