package ru.yandex.chemodan.app.djfs.core.lastfiles;

import java.util.concurrent.ExecutorService;

import lombok.RequiredArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.djfs.core.EventManager;
import ru.yandex.chemodan.app.djfs.core.share.event.UserKickedFromGroupEvent;
import ru.yandex.chemodan.app.djfs.core.share.event.UserLeftGroupEvent;
import ru.yandex.chemodan.app.djfs.core.util.CeleryJobUtils;
import ru.yandex.chemodan.app.djfs.core.util.DjfsAsyncTaskUtils;
import ru.yandex.chemodan.app.djfs.core.util.ExecutorServiceUtils;
import ru.yandex.chemodan.app.djfs.core.util.JsonUtils;
import ru.yandex.chemodan.queller.celery.job.CeleryJob;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.json.JsonValue;

/**
 * @author eoshch
 */
@RequiredArgsConstructor
public class LastFilesCacheUpdater {
    public static TaskId TASK_ID = new TaskId("mpfs.core.last_files.job_handlers.handle_update_last_files_cache");

    private final ExecutorService executorService;
    private final CeleryTaskManager celeryTaskManager;

    private String activeUid(String groupId) {
        return DjfsAsyncTaskUtils.activeUid("update_last_files_cache__" + groupId);
    }

    public void sendUpdateTask(String groupId) {
        MapF<String, JsonValue> kwargs = JsonUtils.objectBuilder()
                .add("gid", groupId)
                .toMap();

        CeleryJob celeryJob = CeleryJobUtils.create(TASK_ID, activeUid(groupId), Duration.standardSeconds(5), kwargs);
        ExecutorServiceUtils.executeWithMdc(executorService, () -> celeryTaskManager.submit(celeryJob));
    }

    @EventManager.EventHandler
    public void handle(UserKickedFromGroupEvent event) {
        sendUpdateTask(event.getShareInfo().getGroupId());
    }

    @EventManager.EventHandler
    public void handle(UserLeftGroupEvent event) {
        sendUpdateTask(event.getShareInfo().getGroupId());
    }
}
