package ru.yandex.chemodan.app.djfs.core.legacy;

import java.util.List;

import com.mongodb.MongoClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.djfs.core.DownloadUrlGenerator;
import ru.yandex.chemodan.app.djfs.core.album.AlbumDao;
import ru.yandex.chemodan.app.djfs.core.album.PersonalAlbumManager;
import ru.yandex.chemodan.app.djfs.core.client.LogReaderHttpClient;
import ru.yandex.chemodan.app.djfs.core.db.DaoProxyFactory;
import ru.yandex.chemodan.app.djfs.core.db.pg.PgShardedDaoContext;
import ru.yandex.chemodan.app.djfs.core.filesystem.DjfsResourceDao;
import ru.yandex.chemodan.app.djfs.core.filesystem.Filesystem;
import ru.yandex.chemodan.app.djfs.core.history.EventHistoryLogger;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.FileMetaProvider;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.FolderMetaProvider;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.ResourcePojoBuilder;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.ExtensionConversionRegistry;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.MicrosoftAppSizeLimitsRegistry;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.MicrosoftAppsDiscoveryRegistry;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.MicrosoftAppsDiscoveryService;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.MicrosoftExtensionConvertSizeLimitRegistry;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.MicrosoftOnlineOfficeEditor;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.OnlineOfficeFileEditor;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.OnlineOfficeFileEditorManager;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.dao.MongoOfficePddDomainDao;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.dao.OfficeAllowedPddDomainDao;
import ru.yandex.chemodan.app.djfs.core.legacy.formatting.office.dao.PgOfficeAllowedPddDomainDao;
import ru.yandex.chemodan.app.djfs.core.legacy.web.LegacyMpfsExceptionHandler;
import ru.yandex.chemodan.app.djfs.core.lock.LockManager;
import ru.yandex.chemodan.app.djfs.core.notification.XivaPushGenerator;
import ru.yandex.chemodan.app.djfs.core.operations.OperationDao;
import ru.yandex.chemodan.app.djfs.core.publication.PublicationManager;
import ru.yandex.chemodan.app.djfs.core.share.GroupDao;
import ru.yandex.chemodan.app.djfs.core.share.GroupLinkDao;
import ru.yandex.chemodan.app.djfs.core.share.ShareInfoManager;
import ru.yandex.chemodan.app.djfs.core.user.ClientInputDataProcessor;
import ru.yandex.chemodan.app.djfs.core.user.UserDao;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.queller.worker.CeleryTaskManager;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author eoshch
 */
@Configuration
public class LegacyContextConfiguration {
    private final DynamicProperty<Boolean> isOfficeAllowedPddDomainsInPG =
            new DynamicProperty<>("djfs.common.is-office-allowed-pdd-domains-in-pg", true);

    @Bean
    public LegacyMpfsExceptionHandler legacyMpfsExceptionHandler(LockManager lockManager,
            ShareInfoManager shareInfoManager)
    {
        return new LegacyMpfsExceptionHandler(lockManager, shareInfoManager);
    }

    @Bean
    public LegacyFilesystemActions legacyFilesystemActions(Filesystem filesystem, OperationDao operationDao,
                CeleryTaskManager celeryTaskManager, EventHistoryLogger eventHistoryLogger,
                ShareInfoManager shareInfoManager, UserDao userDao, AlbumDao albumDao, PersonalAlbumManager personalAlbumManager,
                ResourcePojoBuilder resourcePojoBuilder,
                XivaPushGenerator xivaPushGenerator, PublicationManager publicationManager,
                @Value("${djfs.public.blockings-check-by-hash-enabled}") boolean isBlockingsCheckByHashEnabled,
                ClientInputDataProcessor clientInputDataProcessor)
    {
        return new LegacyFilesystemActions(filesystem, operationDao, celeryTaskManager, eventHistoryLogger,
                shareInfoManager, userDao, albumDao, personalAlbumManager, resourcePojoBuilder,
                xivaPushGenerator, publicationManager, clientInputDataProcessor, isBlockingsCheckByHashEnabled);
    }

    @Bean
    public ResourcePojoBuilder djfsResourcePojoBuilder(ShareInfoManager shareInfoManager,
            FileMetaProvider fileMetaProvider, FolderMetaProvider folderMetaProvider)
    {
        return new ResourcePojoBuilder(shareInfoManager, fileMetaProvider, folderMetaProvider);
    }

    @Bean
    public FileMetaProvider fileMetaProvider(Blackbox2 blackbox2, DownloadUrlGenerator downloadUrlGenerator,
            LogReaderHttpClient logReaderHttpClient, PublicationManager publicationManager, Filesystem filesystem,
            OnlineOfficeFileEditorManager onlineOfficeFileEditorManager, ShareInfoManager shareInfoManager)
    {
        return new FileMetaProvider(blackbox2, downloadUrlGenerator, logReaderHttpClient, filesystem,
                publicationManager, onlineOfficeFileEditorManager, shareInfoManager);
    }

    @Bean
    public FolderMetaProvider folderMetaProvider(Blackbox2 blackbox2, LogReaderHttpClient logReaderHttpClient,
                                                 PublicationManager publicationManager, Filesystem filesystem,
                                                 DjfsResourceDao djfsResourceDao, GroupDao groupDao,
                                                 GroupLinkDao groupLinkDao)
    {
        return new FolderMetaProvider(filesystem, blackbox2, publicationManager, logReaderHttpClient, djfsResourceDao,
                groupDao, groupLinkDao);
    }

    @Bean
    public MicrosoftOnlineOfficeEditor microsoftOnlineOfficeEditor(Blackbox2 blackbox2,
            MicrosoftAppsDiscoveryService microsoftAppsDiscoveryService,
            ExtensionConversionRegistry extensionConversionRegistry,
            MicrosoftAppSizeLimitsRegistry microsoftAppSizeLimitsRegistry,
            MicrosoftExtensionConvertSizeLimitRegistry microsoftExtensionConvertSizeLimitRegistry,
                                                                   OfficeAllowedPddDomainDao officeAllowedPddDomainDao)
    {
        return new MicrosoftOnlineOfficeEditor(blackbox2, microsoftAppsDiscoveryService,
                extensionConversionRegistry, microsoftAppSizeLimitsRegistry, microsoftExtensionConvertSizeLimitRegistry, officeAllowedPddDomainDao);
    }

    @Bean
    public OnlineOfficeFileEditorManager onlineOfficeFileEditorManager(List<OnlineOfficeFileEditor> editors) {
        return new OnlineOfficeFileEditorManager(Cf.x(editors));
    }

    @Bean
    public MicrosoftExtensionConvertSizeLimitRegistry microsoftExtensionConvertSizeLimitRegistry(@Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager) {
        MicrosoftExtensionConvertSizeLimitRegistry microsoftExtensionConvertSizeLimitRegistry =
                new MicrosoftExtensionConvertSizeLimitRegistry(zkRoot.child("djfs-office-microsoft-extension-convert-limit"));
        zkManager.addClient(microsoftExtensionConvertSizeLimitRegistry);
        return microsoftExtensionConvertSizeLimitRegistry;
    }

    @Bean
    public MicrosoftAppSizeLimitsRegistry microsoftAppSizeLimitsRegistry(@Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager) {
        MicrosoftAppSizeLimitsRegistry microsoftAppSizeLimitsRegistry =
                new MicrosoftAppSizeLimitsRegistry(zkRoot.child("djfs-office-microsoft-app-limits"));
        zkManager.addClient(microsoftAppSizeLimitsRegistry);
        return microsoftAppSizeLimitsRegistry;
    }

    @Bean
    public ExtensionConversionRegistry extensionConversionRegistry(@Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager) {
        ExtensionConversionRegistry extensionConversionRegistry =
                new ExtensionConversionRegistry(zkRoot.child("djfs-office-microsoft-extension-conversion"));
        zkManager.addClient(extensionConversionRegistry);
        return extensionConversionRegistry;
    }

    @Bean
    public MicrosoftAppsDiscoveryRegistry microsoftAppsDiscoveryRegistry(@Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager) {
        MicrosoftAppsDiscoveryRegistry microsoftAppsDiscoveryRegistry =
                new MicrosoftAppsDiscoveryRegistry(zkRoot.child("djfs-office-microsoft-discovery-apps"));
        zkManager.addClient(microsoftAppsDiscoveryRegistry);
        return microsoftAppsDiscoveryRegistry;
    }

    @Bean
    public MicrosoftAppsDiscoveryService microsoftAppsDiscoveryService(MicrosoftAppsDiscoveryRegistry microsoftAppsDiscoveryRegistry,
            HttpClientConfigurator microsoftAppsHttpClientConfigurator)
    {
        return new MicrosoftAppsDiscoveryService(microsoftAppsDiscoveryRegistry, microsoftAppsHttpClientConfigurator.configure());
    }

    @Bean
    @OverridableValuePrefix("microsoftApps")
    public HttpClientConfigurator microsoftAppsHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }


    @Bean
    public MongoOfficePddDomainDao mongoOfficePddDomainDao(@Qualifier("commonMongoClient") MongoClient mongoClient) {
        return new MongoOfficePddDomainDao(mongoClient);
    }

    @Bean
    public PgOfficeAllowedPddDomainDao pgOfficeAllowedPddDomainDao(PgShardedDaoContext dependencies) {
        return new PgOfficeAllowedPddDomainDao(dependencies);
    }

    @Bean
    @Primary
    public OfficeAllowedPddDomainDao officeAllowedPddDomainDao(DaoProxyFactory daoProxyFactory, MongoOfficePddDomainDao mongoDao, PgOfficeAllowedPddDomainDao pgDao) {
        return daoProxyFactory.create(OfficeAllowedPddDomainDao.class, pgDao, mongoDao, isOfficeAllowedPddDomainsInPG::get);
    }

    @Bean
    public ClientInputDataProcessor clientInputDataProcessor() {
        return new ClientInputDataProcessor();
    }

}
