package ru.yandex.chemodan.app.djfs.core.legacy;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.lang.StringUtils;

public class PreviewFormattingOptions extends DefaultObject {
    private Option<String> customPreviewSize;
    private Option<String> customPreviewCrop;
    private Option<String> previewQuality;
    private Option<String> allowBigSize;
    private Option<String> customPreviewType;
    private Option<String> customPreviewAnimate;

    private static final SetF<String> supportedPreviewTypes = Cf.set("jpg", "png", "gif", "webp", "bmp");

    public static final PreviewFormattingOptions EMPTY = new PreviewFormattingOptions(
            Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty());


    public PreviewFormattingOptions(Option<String> customPreviewSize,
            Option<String> customPreviewCrop, Option<String> previewQuality,
            Option<String> allowBigSize, Option<String> customPreviewType,
            Option<String> customPreviewAnimate)
    {
        this.customPreviewSize = customPreviewSize;
        this.customPreviewCrop = customPreviewCrop;
        this.previewQuality = previewQuality;
        this.allowBigSize = allowBigSize;
        this.customPreviewType = customPreviewType;
        this.customPreviewAnimate = customPreviewAnimate;
    }

    public Option<String> getCustomPreviewSize() {
        return customPreviewSize;
    }

    public Option<String> getCustomPreviewCrop() {
        if (!customPreviewCrop.isPresent()) {
            return Option.empty();
        }

        return StringUtils.isNumericArabic(customPreviewCrop.get()) ? customPreviewCrop : Option.empty();
    }

    public Option<String> getPreviewQuality() {
        return previewQuality;
    }

    public boolean isAllowBigSize() {
        return allowBigSize.isPresent() &&
                (Boolean.parseBoolean(allowBigSize.get()) || "1".equals(allowBigSize.get()));
    }

    public Option<String> getCustomPreviewType() {
        if (customPreviewType.isPresent() && supportedPreviewTypes.containsTs(customPreviewType.get().toLowerCase())) {
            return customPreviewType;
        } else {
            return Option.empty();
        }
    }

    public boolean isCustomPreviewAnimate() {
        return customPreviewAnimate.isPresent() &&
                (Boolean.parseBoolean(customPreviewAnimate.get()) || "1".equals(customPreviewSize.get()));
    }

}
