package ru.yandex.chemodan.app.djfs.core.legacy;

import lombok.RequiredArgsConstructor;

import ru.yandex.chemodan.app.djfs.core.filesystem.model.DjfsResourcePath;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;

@ActionResultPojo
@BenderBindAllFields
public class TrashAppendResultPojo {
    @BenderPart(name = "this", strictName = true)
    public final Result result;

    @BenderBindAllFields
    @RequiredArgsConstructor
    public static class Result {
        @BenderPart(name = "id", strictName = true)
        public final String targetPath;
        @BenderPart(name = "id_old", strictName = true)
        public final String sourcePath;
    }

    TrashAppendResultPojo(DjfsResourcePath sourcePath, DjfsResourcePath targetPath) {
        result = new Result(targetPath.getPath(), sourcePath.getPath());
    }
}
