package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import lombok.Getter;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;


@Getter
public class LegacyAlbumsException extends LegacyMpfsException {
    private final HttpStatus httpStatusCode;
    private final int code;
    private final String pythonClassName;
    private final String title;

    private LegacyAlbumsException(DjfsException cause, HttpStatus httpStatusCode, int code, String pythonClassName, String title) {
        super(cause);
        this.httpStatusCode = httpStatusCode;
        this.code = code;
        this.pythonClassName = pythonClassName;
        this.title = title;
    }

    static public LegacyAlbumsException JSONBodyExpected(DjfsException cause) {
        //    ALBUMS_JSON_BODY_EXPECTED
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 154, "AlbumsJsonBodyExpectedError", "");
    }

    static public LegacyAlbumsException coverIndexOutOfRange(DjfsException cause) {
        //    ALBUMS_COVER_INDEX_OUT_OF_RANGE
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 155, "AlbumsCoverIndexOutOfRangeError", "");
    }

    static public LegacyAlbumsException unableToUseAlbumAsCover(DjfsException cause) {
        //    ALBUMS_UNABLE_TO_USE_ALBUM_AS_COVER
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 156, "AlbumsUnableToUseAlbumAsCoverError", "");
    }

    static public LegacyAlbumsException unableToUseFolderAsCover(DjfsException cause) {
        //    ALBUMS_UNABLE_TO_USE_FOLDER_AS_COVER
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 157, "AlbumsUnableToUseFolderAsCoverError", "");
    }

    static public LegacyAlbumsException wrongLayout(DjfsException cause) {
        //    ALBUMS_WRONG_LAYOUT
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 158, "AlbumsWrongLayoutError", "");
    }

    static public LegacyAlbumsException albumIsNotPublic(DjfsException cause) {
        //    ALBUMS_IS_NOT_PUBLIC
        return new LegacyAlbumsException(cause, HttpStatus.NOT_FOUND, 159, "AlbumsIsNotPublicError", "album is not public");
    }

    static public LegacyAlbumsException unableToPublishUnsaved(DjfsException cause) {
        //    ALBUMS_UNABLE_TO_PUBLISH_UNSAVED
        return new LegacyAlbumsException(cause, HttpStatus.FORBIDDEN, 161, "AlbumsUnableToPublishUnsavedError", "");
    }

    static public LegacyAlbumsException unableToAppendItem(DjfsException cause) {
        //    ALBUMS_UNABLE_TO_APPEND_ITEM
        return new LegacyAlbumsException(cause, HttpStatus.NOT_FOUND, 163, "AlbumsUnableToAppendItem", "");
    }

    static public LegacyAlbumsException coverWrongOffsetType(DjfsException cause) {
        //    ALBUMS_COVER_WRONG_OFFSET_TYPE
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 164, "AlbumsCoverOffsetWrongTypeError", "");
    }

    static public LegacyAlbumsException postToSocialFailed(DjfsException cause) {
        //    ALBUMS_POST_TO_SOCIAL_FAILED
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 165, "AlbumsPostToSocialFailedError", "");
    }

    static public LegacyAlbumsException updateSocialCoverFailed(DjfsException cause) {
        //    ALBUMS_UPDATE_SOCIAL_COVER_FAILED
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 166, "AlbumsUpdateSocialCoverError", "");
    }

    static public LegacyAlbumsException providerNotFound(DjfsException cause) {
        //    ALBUMS_PROVIDER_NOT_FOUND_ERROR
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 176, "AlbumsProviderNotFound", "");
    }

    static public LegacyAlbumsException itemMissed(DjfsException cause) {
        //    ALBUM_ITEM_MISSED
        return new LegacyAlbumsException(cause, HttpStatus.NOT_FOUND, 223, "AlbumItemMissed", "album's item was not found");
    }

    static public LegacyAlbumsException wrongGeneratedType(DjfsException cause) {
        //    ALBUM_WRONG_GENERATED_TYPE
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 271, "AlbumsWrongGeneratedType", "");
    }

    static public LegacyAlbumsException titleTooLong(DjfsException cause) {
        //    ALBUM_TITLE_TOO_LONG
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 277, "AlbumTitleTooLong", "");
    }

    static public LegacyAlbumsException getBodyExpected(DjfsException cause) {
        //    ALBUMS_GET_BODY_EXPECTED
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 283, "AlbumsGETBodyExpectedError", "");
    }

    static public LegacyAlbumsException tooManyResources(DjfsException cause) {
        //    ALBUMS_TOO_MANY_RESOURCES
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 284, "AlbumsTooManyResourcesError", "");
    }

    static public LegacyAlbumsException invalidJSONBody(DjfsException cause) {
        //    ALBUMS_INVALID_JSON_BODY
        return new LegacyAlbumsException(cause, HttpStatus.BAD_REQUEST, 285, "AlbumsInvalidJSONBodyError", "");
    }

    static public LegacyAlbumsException albumAlreadyExists(DjfsException cause) {
        //    ALBUM_ALREADY_EXISTS
        return new LegacyAlbumsException(cause, HttpStatus.CONFLICT, 286, "AlbumAlreadyExists", "Album already exists");
    }

    static public LegacyAlbumsException itemCanNotBeMoved(DjfsException cause) {
        //    ALBUM_ITEM_CAN_NOT_BE_MOVED
        return new LegacyAlbumsException(cause, HttpStatus.GONE, 288, "AlbumItemCanNotBeMoved", "");
    }

    static public LegacyAlbumsException albumNotFound(DjfsException cause) {
        //    ALBUM_NOT_FOUND
        return new LegacyAlbumsException(cause, HttpStatus.NOT_FOUND, 289, "PhotoAlbumNotFoundError", "Album not found");
    }

    static public LegacyAlbumsException unableToDelete(DjfsException cause) {
        //    ALBUMS_UNABLE_TO_DELETE
        return new LegacyAlbumsException(cause, HttpStatus.FORBIDDEN, 290, "AlbumsUnableToDelete", "");
    }
}
