package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyMd5UnsupportedException extends LegacyMpfsException {
    public LegacyMd5UnsupportedException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    @Override
    public int getCode() {
        return 252;
    }

    @Override
    public String getTitle() {
        return "md5 check supported only for files";
    }

    @Override
    public String getPythonClassName() {
        return "MD5CheckNotSupportedError";
    }
}
