package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

/**
 * @author eoshch
 */
public abstract class LegacyMpfsException extends DjfsException {
    public LegacyMpfsException(DjfsException cause) {
        super(cause);
    }

    public LegacyMpfsException(String message) {
        super(message);
    }

    public abstract HttpStatus getHttpStatusCode();

    public abstract int getCode();

    public abstract String getTitle();

    public abstract String getPythonClassName();

    public Option<MapF<String, String>> getAdditionalData() {
        return Option.empty();
    }
}
