package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyOfficeTooLargeException extends LegacyMpfsException {

    public LegacyOfficeTooLargeException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.REQUEST_ENTITY_TOO_LONG;
    }

    @Override
    public int getCode() {
        return 171;
    }

    @Override
    public String getTitle() {
        return "file too large";
    }

    @Override
    public String getPythonClassName() {
        return "OfficeFileTooLargeError";
    }
}
