package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

/**
 * @author eoshch
 */
public class LegacyPathErrorException extends LegacyMpfsException {
    public LegacyPathErrorException(DjfsException cause) {
        super(cause);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.NOT_FOUND;
    }

    @Override
    public int getCode() {
        return 77;
    }

    @Override
    public String getTitle() {
        return "Wrong path";
    }

    @Override
    public String getPythonClassName() {
        return "InfoPathError";
    }
}
