package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyResourceAlreadyExists extends LegacyMpfsException {
    public LegacyResourceAlreadyExists(DjfsException exception) {
        super(exception);
    }

    public LegacyResourceAlreadyExists(String message) {
        super(message);
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.PRECONDITION_FAILED;
    }

    @Override
    public int getCode() {
        return 32;
    }

    @Override
    public String getTitle() {
        return "copy: resource already exists";
    }

    @Override
    public String getPythonClassName() {
        return "CopyTargetExists";
    }
}
