package ru.yandex.chemodan.app.djfs.core.legacy.exception;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.djfs.core.DjfsException;
import ru.yandex.commune.a3.action.http.HttpStatus;

public class LegacyResourceBlockedException extends LegacyMpfsException {
    public final Option<MapF<String, String>> data;

    public LegacyResourceBlockedException(DjfsException cause) {
        super(cause);
        this.data = Option.empty();
    }

    public LegacyResourceBlockedException(DjfsException cause, Option<MapF<String, String>> data) {
        super(cause);
        this.data = data;
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return HttpStatus.CONFLICT;
    }

    @Override
    public int getCode() {
        return 96;
    }

    @Override
    public String getTitle() {
        return "resource blocked";
    }

    @Override
    public String getPythonClassName() {
        return "ResourceBlocked";
    }

    @Override
    public Option<MapF<String, String>> getAdditionalData() {
        return data;
    }
}
